# Nom du Projet

Ce projet utilise [CodeIgniter 4](https://codeigniter.com/) comme framework PHP.

## Prérequis

- PHP >= 8.1
- Composer
- MySQL/MariaDB
- Extensions PHP : intl, mbstring, json, mysqlnd, libcurl

## Installation

1. **Cloner le dépôt :** 
   ```sh
   git clone https://github.com/cyrusien/gestionFerme.git
   cd gestionFerme/backend
   ```

2. **Installer les dépendances PHP :**
   ```sh
   composer install
   ```

3. **Configurer l’environnement :**
   - Copier le fichier d’exemple :
     ```sh
     cp env .env
     ```
   - Modifier les variables dans `.env` selon votre configuration (base de données, URL, etc.).

4. **Créer la base de données MySQL :**
   ```sql
   CREATE DATABASE IF NOT EXISTS ferme;
   CREATE USER 'ferme'@'localhost' IDENTIFIED BY 'Ferme@1234!';
   GRANT ALL PRIVILEGES ON ferme.* TO 'ferme'@'localhost';
   FLUSH PRIVILEGES;
   ```

5. **Lancer les migrations pour créer les tables :**
   ```sh
   php spark migrate
   ```

6. **Démarrer le serveur de développement :**
   ```sh
   php spark serve
   ```
   Accédez à [http://localhost:8080](http://localhost:8080)

## Notes

- Configurez votre serveur web pour pointer vers le dossier `public`.
- Consultez la documentation CodeIgniter pour plus d’informations.

---

ALTER TABLE `vente` CHANGE `prix_vente` `prix_vente` FLOAT NOT NULL, CHANGE `montant_total` `montant_total` FLOAT NOT NULL;

ALTER TABLE `benefice_vente_bande` CHANGE `prix_unitaire` `prix_unitaire` FLOAT NOT NULL DEFAULT '0';

update vente set `total_vente`=montant_total where id!=??;