<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');

$routes->group("api", function ($routes) {
    $routes->get("statistiques/(:num)", "Home::getStatistics/$1"); //iduser Route pour les statistiques
    $routes->get("coutProduction/(:num)/(:num)", "Home::coutProduction/$1/$2"); //iduser idferme

    $routes->group("auths", function ($routes) { 
        $routes->post("register", "UtilisateurController::register");
        $routes->post("login", "UtilisateurController::login");
        $routes->get("users", "UtilisateurController::index",['filter' => 'authFilter']);
    });

    $routes->group("ferme",['filter' => 'authFilter'], function ($routes) { 
        $routes->post("addFerme", "FermeController::create"); // Route pour l'ajout d'une ferme
        $routes->get("loadFerme", "FermeController::index"); // Route pour charger les fermes
        $routes->get("loadFermeUSer/(:num)", "FermeController::listUserFerme/$1"); // Route pour charger les fermes de l'utilisateur connecté
        $routes->get("showOneFerme/(:num)", "FermeController::show/$1"); // Route pour afficher une ferme par son id
        $routes->post("editFerme/(:num)", "FermeController::update/$1"); // Route pour modifier une ferme par son id
        $routes->delete("deleteFerme/(:num)", "FermeController::delete/$1"); // Route pour supprimer une ferme par son id
    });

    $routes->group("bande",['filter' => 'authFilter'], function ($routes) { 
        $routes->post("addBande", "BandeController::create");   // Route pour l'ajout d'une bande
        $routes->get("loadBande", "BandeController::index"); // Route pour charger les bandes
        $routes->get("showOneBande/(:num)", "BandeController::show/$1"); // Route pour afficher une bande par son id
        $routes->post("editBande/(:num)", "BandeController::update/$1"); // Route pour modifier une bande par son id
        $routes->delete("deleteBande/(:num)", "BandeController::delete/$1"); // Route pour supprimer une bande par son id
        $routes->get("loadBandeByFerme/(:num)", "BandeController::loadBandeByFerme/$1"); // Route pour charger les bandes par ferme
        $routes->get("loadBandeFerme/(:num)/(:num)", "BandeController::loadBandeByFerme/$1/$2"); // Route pour charger les bandes par ferme
        
        $routes->post("addMortalite", "MortaliteController::create");   // Route pour l'ajout d'une mortalité dans une bande
        $routes->get("loadMortalite", "MortaliteController::index");   // Route pour l'ajout d'une mortalité dans une bande

        // Cout de production par bande (CRUD)
        $routes->post("addCoutProduction", "CoutProductionBandeController::create");
        $routes->get("loadCoutProduction", "CoutProductionBandeController::index");
        $routes->get("showCoutProduction/(:num)", "CoutProductionBandeController::show/$1");
        $routes->post("editCoutProduction/(:num)", "CoutProductionBandeController::update/$1");
        $routes->delete("deleteCoutProduction/(:num)", "CoutProductionBandeController::delete/$1");
        $routes->get("loadCoutByBande/(:num)", "CoutProductionBandeController::listByBande/$1");
    });

    $routes->group("aliment", ['filter' => 'authFilter'], function ($routes) { 
        $routes->get("/", "AlimentController::index");
        $routes->get("loadAliment/(:num)", "AlimentController::ListeAlimentUser/$1");
        $routes->get("getTypeAliment", "AlimentController::listeTypeAliment");
        $routes->post("addAliment", "AlimentController::create");   // Route pour l'ajout d'une bande
        $routes->get("getsAliments/(:num)", "AlimentController::listesAliments/$1");
        $routes->get("calculQuantiteAliment/(:num)", "AlimentController::stockOneAliment/$1");
        $routes->post("addDistributionAliment", "DistributionAlimentController::create");
        $routes->get("getDistributionAliment/(:num)", "DistributionAlimentController::listesDistributionsAliments/$1");
    });

    $routes->group("medicament", ['filter' => 'authFilter'], function ($routes) { 
        $routes->get("/", "MedicamentController::index");
        $routes->post("addMedicament", "MedicamentController::create");   // Route pour l'ajout d'une bande
        $routes->get("getsMedicaments/(:num)", "MedicamentController::listesMedicaments/$1");
        $routes->get("getsAllMedicaments/(:num)", "MedicamentController::listesAllMedicaments/$1");

        $routes->get("calculQuantiteMedicament/(:num)", "DistributionMedicamentController::stockOneMedicament/$1");
        $routes->post("addDistributionMedicament", "DistributionMedicamentController::create");
        $routes->get("getDistributionMedicament/(:num)", "DistributionMedicamentController::listesDistributionsMedicaments/$1");
    });   
    
    $routes->group("vente", ['filter' => 'authFilter'], function ($routes) { 
        $routes->get("/", "VenteController::index");
        $routes->post("createVente", "VenteController::create");   // Route pour l'ajout d'une vente
        $routes->get("loadVente", "VenteController::index");

        // Benefice lié aux ventes
        $routes->post("createBenefice", "BeneficeVenteBandeController::create");
        $routes->get("loadBenefice", "BeneficeVenteBandeController::index");
        $routes->get("showBenefice/(:num)", "BeneficeVenteBandeController::show/$1");
        $routes->get("showBeneficeByVente/(:num)", "BeneficeVenteBandeController::showByVente/$1");
        $routes->post("editBenefice/(:num)", "BeneficeVenteBandeController::update/$1");
        $routes->delete("deleteBenefice/(:num)", "BeneficeVenteBandeController::delete/$1");
    });
});   


/*
$routes->group('', ['filter' => 'cors'], static function (RouteCollection $routes): void {
    $routes->options('api/(:any)', static function () {});
});*/
