<?php

namespace App\Controllers;

use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\RESTful\ResourceController;
use App\Models\CoutProductionBandeModel;
use CodeIgniter\API\ResponseTrait;

class CoutProductionBandeController extends ResourceController
{
    use ResponseTrait;
    protected $format = 'json';
    private $coutModel;
    private $validation;

    public function __construct()
    {
        $this->coutModel = new CoutProductionBandeModel();
        $this->validation = \Config\Services::validation();
    }

    public function index()
    {
        $bande_id = $this->request->getGet('bande_id');
        if ($bande_id) {
            $data = $this->coutModel->where('bande_id', $bande_id)->orderBy('date_jour', 'ASC')->findAll();
        } else {
            $data = $this->coutModel->orderBy('date_jour', 'ASC')->findAll();
        }
        return $this->respond(['status' => 200, 'error' => false, 'message' => null, 'data' => $data]);
    }

    public function show($id = null)
    {
        $data = $this->coutModel->find($id);
        if (!$data) return $this->failNotFound('Cout production not found');
        return $this->respond($data);
    }

    public function create()
    {
        $data = $this->request->getJSON(true);
        $rules = [
            'bande_id' => 'required|integer',
            'date_jour' => 'required|valid_date[Y-m-d]',
            'cout_production' => 'required|decimal',
        ];
        if (!$this->validate($rules)) {
            return $this->respondCreated(['status' => 200, 'error' => true, 'messages' => 'Validation error', 'message' => $this->validator->getErrors(), 'data' => []]);
        }
        $insert = [
            'bande_id' => $data['bande_id'],
            'ferme_id' => $data['ferme_id'],
            'date_jour' => $data['date_jour'],
            'cout_production' => $data['cout_production'],
            'age_jours' => $data['age_jours'] ?? null,
            'note' => $data['note'] ?? null,
        ];
        $id = $this->coutModel->insert($insert);
        if (!$id) {
            return $this->respondCreated(['status' => 200, 'error' => true, 'messages' => 'Erreur lors de l\'enregistrement', 'message' => $this->coutModel->errors(), 'data' => []]);
        }
        $insert['id'] = $id;
        return $this->respondCreated(['status' => 201, 'error' => false, 'messages' => 'Enregistré', 'data' => $insert]);
    }

    public function update($id = null)
    {
        $payload = $this->request->getJSON(true);
        if (!$this->coutModel->find($id)) return $this->failNotFound('Cout production not found');
        if ($this->coutModel->update($id, $payload) === false) {
            return $this->failValidationErrors($this->coutModel->errors());
        }
        return $this->respond($this->coutModel->find($id));
    }

    public function delete($id = null)
    {
        if (!$this->coutModel->find($id)) return $this->failNotFound('Cout production not found');
        $this->coutModel->delete($id);
        return $this->respondDeleted(['id' => $id, 'message' => 'Cout production deleted']);
    }
}
