<?php

namespace App\Controllers;

use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\RESTful\ResourceController;
use App\Models\AlimentModel;
use App\Models\MedicamentModel;
use App\Models\BandeModel;
use App\Models\DistributionAlimentModel;
use App\Models\DistributionMedicamentModel;
use App\Models\MortaliteModel;
use App\Models\FermeModel;
use App\Models\VenteModel;
use App\Models\CoutProductionBandeModel;

use CodeIgniter\API\ResponseTrait;

class Home extends ResourceController
{
    use ResponseTrait;
    protected $format    = 'json';
    private $ferme;
    private $aliment;
    private $bande;
    private $medicament;
    private $distributionAliment;
    private $distributionMedicament;
    private $mortalite;
    private $vente;
    private $coutProductionBande;

    private $validation;

    public function __construct()
    {
        $this->ferme = new FermeModel();
        $this->aliment = new AlimentModel();
        $this->bande = new BandeModel();
        $this->medicament = new MedicamentModel();
        $this->distributionAliment = new DistributionAlimentModel();
        $this->distributionMedicament = new DistributionMedicamentModel();
        $this->mortalite = new MortaliteModel();
        $this->vente = new VenteModel();
        $this->coutProductionBande = new CoutProductionBandeModel();

        // Load the validation service
        helper(['form', 'url']);
        $this->validation = \Config\Services::validation();
    }

    public function index(){
        $response = [
            'status' => 200,
            'error' => false,
            'messages' => 'Aliments chargés avec succès',
            'message' => null,
            'data' => $this->aliment->orderBy('nom', 'ASC')
                                       ->findAll()
        ];
        return $this->respondCreated($response);
    }
    
    public function getStatistics($idUser = null) {
        if (is_null($idUser)) {
            $response = [
                'status' => 200,
                'error' => true,    
                'messages' => 'ID de l\'utilisateur requis',
                'message' => null,
                'data' => []
            ];
            return $this->respondCreated($response);
        }

        //$userFerme = $this->ferme->loadFermeByUserId($idUser, 'active');
        $ferme = $this->ferme->getOneFermeById($idUser, 'active');

        // Vérifier si des fermes existent pour cet utilisateur
        if(!$ferme)  {
            $response = [
                'status' => 200,
                'error' => true,
                'messages' => 'Aucune ferme trouvée pour cet utilisateur',
                'message' => null,
                'data' => []
            ];
            return $this->respondCreated($response);
        }

        //counter ne nombre de bande
        $total_bande = $this->bande->countBande($ferme['id']);
        if($total_bande==0)  {
            $response = [
                'status' => 200,
                'error' => true,
                'messages' => 'Aucune bande trouvée pour cet utilisateur',
                'message' => null,
                'data' => []
            ];
            return $this->respondCreated($response);
        }
        elseif($total_bande==1)  {
            //recuperer les infos sur la bande active
            $bande = $this->bande->getActiveBandeByFerme($ferme['utilisateur_id']);
            // Vérifier si des bandes existent pour cet utilisateur
            if(!$bande)  {
                $response = [
                    'status' => 200,
                    'error' => true,
                    'messages' => 'Aucune bande trouvée pour cet utilisateur',
                    'message' => null,
                    'data' => []
                ];
                return $this->respondCreated($response);
            }
            $response = [
                'status' => 200,
                'error' => false,
                'messages' => 'Statistiques chargées avec succès',
                'message' => null,
                'data' => [
                    'totalFermes' => $this->ferme->where('utilisateur_id', $idUser)->countAllResults(),
                    'totalAliments' => $this->aliment->countTotalAliments($idUser,$bande['id']),
                    'totalMedicaments' => $this->medicament->countTotalMedicaments($idUser,$bande['id']),
                    'totalDistributionsAliment' => $this->distributionAliment->getTotalDistributionAliments($bande['id']),
                    'totalDistributionsMedicament' => $this->distributionMedicament->getTotalDistributionMedicaments($bande['id']),
                    'totalBandes' => [ 'total_bande' => $this->bande->getTotalBande($bande['id']),
                                    'total_bande_mort' => $this->bande->getTotalMortCartonBande($bande['id']),
                                        'total_reste' => $this->mortalite->getSujetRestant($bande['id']),
                                        'total_mortalites' => $this->mortalite->countTotalMortalites($bande['id']),
                                        'total_mort' =>  $this->mortalite->countTotalMortalites($bande['id'])+$this->bande->getTotalMortCartonBande($bande['id'])
                                        ],
                    'production' => $this->coutProduction($idUser, $ferme['id']),
                    'totalDistributionsAlimentT' => $this->distributionAliment->getTotalDistributionAliments(),
                    'totalDistributionsMedicamentT' => $this->distributionMedicament->getTotalDistributionMedicaments(),
                ]
            ];
            //return $this->respondCreated($response);
        }
        else{
            //recuperer les infos sur la bande active
            $bande = $this->bande->getActiveBandeByFerme($ferme['utilisateur_id']);
            // Vérifier si des bandes existent pour cet utilisateur
            if(!$bande)  {
                $response = [
                    'status' => 200,
                    'error' => true,
                    'messages' => 'Aucune bande trouvée pour cet utilisateur',
                    'message' => null,
                    'data' => []
                ];
                return $this->respondCreated($response);
            }
            // $response = [
            //     'status' => 201,
            //     'error' => false,
            //     'messages' => 'Statistiques chargées avec succès',
            //     'message' => null               
            // ];
            $response['data'] = [
            'totalFermes' => $this->ferme->where('utilisateur_id', $idUser)->countAllResults(),
            'totalAliments' => $this->aliment->countTotalAliments($idUser),
            'totalMedicaments' => $this->medicament->countTotalMedicaments($idUser),
            'totalAlimentsBande' => $this->aliment->countTotalAlimentsBande($idUser,$bande['id']),
            'totalMedicamentsBande' => $this->medicament->countTotalMedicamentsBande($idUser,$bande['id']),
            'totalDistributionsAliment' => $this->distributionAliment->getTotalDistributionAlimentsBande($bande['id']),
            'totalDistributionsMedicament' => $this->distributionMedicament->getTotalDistributionMedicamentsBande($bande['id']),
            'totalBandes' => [  'total_bande' => $this->bande->getTotalBande($bande['id']),
                                 'total_bande_mort' => $this->bande->getTotalMortCartonBande($bande['id']),
                                 'total_reste' => $this->mortalite->getSujetRestant($bande['id']),
                                 'total_mortalites' => $this->mortalite->countTotalMortalites($bande['id']),
                                 'total_mort' =>  $this->mortalite->countTotalMortalites($bande['id'])+$this->bande->getTotalMortCartonBande($bande['id'])
                             ],
            'production' => $this->coutProduction_V2($idUser, $ferme['id']),
            'totalDistributionsAlimentT' => $this->distributionAliment->getTotalDistributionAliments(),
            'totalDistributionsMedicamentT' => $this->distributionMedicament->getTotalDistributionMedicaments(),
            ];
            //$response['data']['production'] = $this->coutProduction_V2($idUser, $ferme['id']);
        }
            //calcul du cout des medicaments et aliments restants en stock pour la bande active
            //medicaments
            $medocs = $this->medicament->getMedicamentByBandeUserID($idUser, $bande['id']);
            $coutM= 0;
            foreach ($medocs as $key => $value) {
                $coutM += $value["total"];                
            }
            //aliments
            $aliments = $this->aliment->getAlimentByBandeUserID($idUser, $bande['id']);
            $coutA= 0;
            foreach ($aliments as $key => $value) {
                $coutA += $value["total"];
            }
            $coutBandeActive = [
                'cout_aliments' => $coutA,
                'cout_medicaments' => $coutM,
                'cout_total' => $coutA + $coutM
            ];
            //calcul du cout des medicaments et aliments restants en stock pour la bande precedente
            //medicaments
            $last_Bande = $this->bande->getAvantDerniereBande($ferme['id']);

            $medocs = $this->medicament->getMedicamentResteByBandeUserID($idUser, 'active', $last_Bande);
            $coutM= 0;
            foreach ($medocs as $key => $value) {
                $Tmedocs = $value["quantite"];
                $medocServie = $this->distributionMedicament->getSumMedicamentDistribuer($value["id"],$last_Bande);
                $medocReste = $Tmedocs - $medocServie;
                if($medocReste<0) $medocReste=0;
                $coutM += $medocReste * $value['prix_unitaire'];                
            }
            //aliments
            $aliments = $this->aliment->getAlimentResteByBandeUserID($idUser, 'active', $last_Bande);
            $coutA= 0;
            foreach ($aliments as $key => $value) {
                $Taliment = $value["quantite"];
                $alimentServie = $this->distributionAliment->getSumAlimentDistribuer($value["id"],$last_Bande);
                $alimentReste = $Taliment - $alimentServie;
                if($alimentReste<0) $alimentReste=0;
                $coutA += $alimentReste * $value['prix_unitaire'];
            }
            $coutBandePrecedente = [
                'cout_aliments' => $coutA,
                'cout_medicaments' => $coutM,
                'cout_total' => $coutA + $coutM
            ];
            //calcul du cout des medicaments et aliments acheter dans le bande precedente et distribuée dans la bande active
              //medicaments
            $medocs = $this->distributionMedicament->getMedicamentDistribuerByUSerID($idUser, $bande['id']);
            $coutM= 0;
            foreach ($medocs as $key => $value) {
                $coutM += $value["dose"] * $value['prix_unitaire'];                
            }
            //aliments
            $aliments = $this->distributionAliment->getAlimentDistribuerByUSerID($idUser, $bande['id']);
            $coutA= 0;
            foreach ($aliments as $key => $value) {
                $coutA += $value["quantite"] * $value['prix_unitaire'];
            }
            $coutBandeActiveDist = [
                'cout_aliments' => $coutA,
                'cout_medicaments' => $coutM,
                'cout_total' => $coutA + $coutM
            ];
            
            //calcul du cout total de la bande (active + precedente)
            //a controler
           /* $coutBande = [
                'cout_aliments' => $coutBandeActive['cout_aliments'] + $coutBandePrecedente['cout_aliments']+$coutBandeActiveDist['cout_aliments'],
                'cout_medicaments' => $coutBandeActive['cout_medicaments'] + $coutBandePrecedente['cout_medicaments']+$coutBandeActiveDist['cout_medicaments'],
                'cout_total' => $coutBandeActive['cout_total'] + $coutBandePrecedente['cout_total']+$coutBandeActiveDist['cout_total']
            ];*/
            //version qui marchait avant
            $coutBande = [
                'cout_aliments' => $coutBandeActive['cout_aliments'] + $coutBandePrecedente['cout_aliments'],
                'cout_medicaments' => $coutBandeActive['cout_medicaments'] + $coutBandePrecedente['cout_medicaments'],
                'cout_total' => $coutBandeActive['cout_total'] + $coutBandePrecedente['cout_total']
            ];
            // $response['data'] = [
            //         // 'totalFermes' => $this->ferme->where('utilisateur_id', $idUser)->countAllResults(),
            //         // 'totalAliments' => $this->aliment->countTotalAliments($idUser),
            //         // 'totalMedicaments' => $this->medicament->countTotalMedicaments($idUser),
            //         // 'totalAlimentsBande' => $this->aliment->countTotalAlimentsBande($idUser,$bande['id']),
            //         // 'totalMedicamentsBande' => $this->medicament->countTotalMedicamentsBande($idUser,$bande['id']),
            //         // 'totalDistributionsAliment' => $this->distributionAliment->getTotalDistributionAlimentsBande($bande['id']),
            //         // 'totalDistributionsMedicament' => $this->distributionMedicament->getTotalDistributionMedicamentsBande($bande['id']),
            //         // 'totalBandes' => [  'total_bande' => $this->bande->getTotalBande($bande['id']),
            //         //                     'total_bande_mort' => $this->bande->getTotalMortCartonBande($bande['id']),
            //         //                     'total_reste' => $this->mortalite->getSujetRestant($bande['id']),
            //         //                     'total_mortalites' => $this->mortalite->countTotalMortalites($bande['id']),
            //         //                     'total_mort' =>  $this->mortalite->countTotalMortalites($bande['id'])+$this->bande->getTotalMortCartonBande($bande['id'])
            //         //                 ],
            //         'production' => $this->coutProduction_V2($idUser, $ferme['id']),
            //         //'totalDistributionsAlimentT' => $this->distributionAliment->getTotalDistributionAliments(),
            //         //'totalDistributionsMedicamentT' => $this->distributionMedicament->getTotalDistributionMedicaments(),
            //     ];
       // }

       // calculer le total des bénéfices via le modèle (évite d'instancier un contrôleur manuellement)
        $beneficeModel = new \App\Models\BeneficeVenteBandeModel();
        $builderBen = $beneficeModel->builder();
        $builderBen->select('SUM(benefice) as total_benefice');
        $builderBen->where('ferme_id', $ferme['id']);
        $builderBen->where('bande_id', $bande['id']);
        $rowBen = $builderBen->get()->getRowArray();
        $totalBenefice = 0.00;
        if ($rowBen && array_key_exists('total_benefice', $rowBen) && $rowBen['total_benefice'] !== null) {
            $totalBenefice = (float) $rowBen['total_benefice'];
        }
        $response['data']['totalBenefice'] = $totalBenefice;
        $response['data']['totalDistributionsAlimentT'] = $this->distributionAliment->getTotalDistributionAliments();
        $response['data']['totalDistributionsMedicamentT'] = $this->distributionMedicament->getTotalDistributionMedicaments();
        $response['data']['couts_active'] = $coutBandeActive;
        $response['data']['couts_precedent'] = $coutBandePrecedente;
        $response['data']['cout_bande'] = $coutBande;
        return $this->respondCreated($response);
    
    }
    
    public function coutProduction($idUser = null, $idFerme = null){
        //recuperer les infos sur la bande active
        $bande = $this->bande->getActiveBandeByFerme($idFerme);
       // $prix_unitaire_poussin = (float)$bande['prix_unitaire'];
        $total_mortalite =$this->mortalite->countTotalMortalites($bande['id']);
        $qtite_vendu = $this->vente->getQuantiteVente($bande['id']);
        //calcul du nombre de poussin restant
        $reste_poussin = (int)$bande['nb_initial'] - (int)$bande['nb_mort'] - $total_mortalite - $qtite_vendu;
        //liste des aliments
        $liste_aliment = $this->aliment->getAliments($idUser); //id, prix_unitaire, quantite, total
        $cout_aliment = 0;
        foreach ($liste_aliment as $aliment => $keys) {
            $distribuer = $this->distributionAliment->getSumAlimentDistribuer($keys["id"],$bande['id']); //quantité déjà distribuée
            if($keys["quantite"]-$distribuer == 0) $cout_aliment+= $keys["total"];
            else $cout_aliment+= $distribuer*$keys["prix_unitaire"];
        }

        //liste des produits
        $liste_produits = $this->medicament->getMedicaments($idUser); //id, prix_unitaire, quantite, total
        $cout_medicament = 0;
        foreach ($liste_produits as $medicament => $keys) {
            $distribuer = $this->distributionMedicament->getSumMedicamentDistribuer($keys["id"],$bande['id']); //quantité déjà distribuée
            if($keys["quantite"]-$distribuer == 0) $cout_medicament+= $keys["total"];
            else $cout_medicament+= $distribuer*$keys["prix_unitaire"];
        }

        //calcul des dépenses
        $depense = $cout_medicament + $cout_aliment + (float)$bande['total'];
        //total vente
        $total_vente = $this->vente->getTotalVente($bande['id']);
        //capitale restant
        $capital = $depense-$total_vente;
        //cout de production
        if($reste_poussin==0) $production = 0;
        else $production =round(($capital)/$reste_poussin, 3);

        $this->updateCoutProductionBande($idFerme, $bande['id'], $production, date('Y-m-d'));
        
        $response = [
            'totaldepense' => $depense,
            'totalvente' => $total_vente,
            'coutproduction' =>  $production,
            'sujetrestant'  =>  $reste_poussin,
            'coutaliments' => $cout_aliment,
            'coutmedicaments' => $cout_medicament,
            'coutpoussins' => (float)$bande['total'],
            'nombresujetsvendus' => $qtite_vendu,
            'prix_poussin'  => (float)$bande['prix_unitaire'],
            'capital' =>  $capital
         ];
        return $response;
    }

    public function coutProduction_V2($idUser = null, $idFerme = null){
        //recuperer les infos sur la bande active
        $bande = $this->bande->getActiveBandeByFerme($idFerme);
       // $prix_unitaire_poussin = (float)$bande['prix_unitaire'];
        $total_mortalite =$this->mortalite->countTotalMortalites($bande['id']);
        $qtite_vendu = $this->vente->getQuantiteVente($bande['id']);
        //calcul du nombre de poussin restant
        $reste_poussin = (int)$bande['nb_initial'] - (int)$bande['nb_mort'] - $total_mortalite - $qtite_vendu;
        
        //liste des aliments distribués
        $liste_aliment = $this->distributionAliment->getAlimentDistribuerByUSerID($idUser, $bande['id']); //id, prix_unitaire
        //$liste_aliment = $this->aliment->getAliments($idUser); //id, prix_unitaire, quantite, total
        $cout_aliment = 0;
        foreach ($liste_aliment as $aliment => $keys) {
            $alimentInfos = $this->aliment->find($keys["aliment_id"]);
            $qtiteDist = $keys["quantite"]; //quantité déjà distribuée
            if($alimentInfos["quantite"]-$qtiteDist == 0) $cout_aliment+= $alimentInfos["total"];
            else $cout_aliment+= $qtiteDist*$alimentInfos["prix_unitaire"];
           // $distribuer = $this->distributionAliment->getSumAlimentDistribuer($keys["aliment_id"],$bande['id']); //quantité déjà distribuée
           // if($keys["quantite"]-$distribuer == 0) $cout_aliment+= $keys["total"];
            //else $cout_aliment+= $distribuer*$keys["prix_unitaire"];
        }

        //liste des produits
        $liste_produits = $this->distributionMedicament->getMedicamentDistribuerByUSerID($idUser, $bande['id']); //id, prix_unitaire
       // $liste_produits = $this->medicament->getMedicaments($idUser); //id, prix_unitaire, quantite, total
        $cout_medicament = 0;
        foreach ($liste_produits as $medicament => $keys) {
            $medocsInfos = $this->medicament->find($keys["medicament_id"]);
            $qtiteDist = $keys["dose"]; //quantité déjà distribuée
            if($medocsInfos["quantite"]-$qtiteDist == 0) $cout_medicament+= $medocsInfos["total"];
            else $cout_medicament+= $qtiteDist*$medocsInfos["prix_unitaire"];
            //$distribuer = $this->distributionMedicament->getSumMedicamentDistribuer($keys["id"],$bande['id']); //quantité déjà distribuée
            //if($keys["quantite"]-$distribuer == 0) $cout_medicament+= $keys["total"];
            //else $cout_medicament+= $distribuer*$keys["prix_unitaire"];
        }

        //calcul des dépenses
        $depense = $cout_medicament + $cout_aliment + (float)$bande['total'];
        //total vente
        $total_vente = $this->vente->getTotalVente($bande['id']);
        //capitale restant
        $capital = $depense-$total_vente;
        //cout de production
        if($reste_poussin==0) $production = 0;
        else $production =round(($capital)/$reste_poussin, 3);
              
        $response = [
            'totaldepense' => $depense,
            'totalvente' => $total_vente,
            'coutproduction' =>  $production,
            'sujetrestant'  =>  $reste_poussin,
            'coutaliments' => $cout_aliment,
            'coutmedicaments' => $cout_medicament,
            'coutpoussins' => (float)$bande['total'],
            'nombresujetsvendus' => $qtite_vendu,
            'prix_poussin'  => (float)$bande['prix_unitaire'],
            'capital' =>  $capital
         ];
        $this->updateCoutProductionBande($idFerme, $bande['id'], $production, date('Y-m-d'));
        return $response;
    }

    function updateCoutProductionBande($ferme_id, $bande_id, $cout_production, $date_jour = null){
        $data = [
            'cout_production' => $cout_production
        ];
        //recuperer la dernière ligne de cout production pour la bande et la ferme
        $this->coutProductionBande->where('bande_id', $bande_id)
                  ->where('ferme_id', $ferme_id)
                  ->orderBy('date_jour', 'DESC')
                  ->limit(1);
        $coutRow = $this->coutProductionBande->get()->getRowArray();
 
        if($coutRow && date('Y-m-d', strtotime($coutRow['date_jour'])) == date('Y-m-d')){
            $this->coutProductionBande->where('id', $coutRow['id'])
                  ->set($data)
                  ->update();
            return;
        }
        else{
            //inserer une nouvelle ligne
            if($coutRow==null){
                $coutRow['age_jours']=0;
            }
            $insert = [
                'bande_id' => $bande_id,
                'ferme_id' => $ferme_id,
                'date_jour' => $date_jour ? $date_jour : date('Y-m-d'),
                'cout_production' => $cout_production,
                'age_jours' => (int)$coutRow['age_jours']+1
            ];
            $this->coutProductionBande->insert($insert);
        }
       /* $this->coutProductionBande->where('bande_id', $bande_id)
                  ->where('ferme_id', $ferme_id)
                  ->where('date_jour', date('Y-m-d'))
                  ->set($data)
                  ->update();*/
    }
}
