<?php

namespace App\Controllers;

use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\RESTful\ResourceController;
use App\Models\MortaliteModel;
use App\Models\BandeModel;
use CodeIgniter\API\ResponseTrait;

class MortaliteController extends ResourceController
{
    use ResponseTrait;
    protected $format    = 'json';
    private $mortaliteModel;
    private $bandeModel;
    private $validation;

    public function __construct()
    {
        $this->mortaliteModel = new MortaliteModel();
        $this->bandeModel = new BandeModel();
        $this->validation = \Config\Services::validation();
    }
    /**
     * Return an array of resource objects, themselves in array format.
     *
     * @return ResponseInterface
     */
    public function index()
    {
        $response = [
            'status' => 200,
            'error' => false,
            'messages' => 'Bandes chargées avec succès',
            'message' => null,
            'data' => $this->mortaliteModel->loadMortalite()
        ];
        return $this->respondCreated($response);
    }

    /**
     * Return the properties of a resource object.
     *
     * @param int|string|null $id
     *
     * @return ResponseInterface
     */
    public function show($id = null)
    {
        //
    }

    /**
     * Return a new resource object, with default properties.
     *
     * @return ResponseInterface
     */
    public function new()
    {
        //
    }

    /**
     * Create a new resource object, from "posted" parameters.
     *
     * @return ResponseInterface
     */
    public function create()
    {
        $data = $this->request->getJSON(true);

        // Définir les règles de validation
        $rules = [
            'ferme_id'      => 'required|integer',
            'bande_id'      => 'required|integer',
            'cause'        => 'required|min_length[2]|max_length[100]',
            'date_mortalite'    => 'required|valid_date[Y-m-d]',
            'nombreMort'       => 'required|integer'
        ]; 
        $messages = [
            'ferme_id'        => ['required' => 'La ferme est requise.'],
            'bande_id'        => ['required' => 'La bande est requise.'],
            'cause'        => ['required' => 'La cause  de la bande est requis.',
                                  'min_length' => 'La cause  de la bande doit comporter au moins 2 caractères.',
                                  'max_length' => 'La cause  de la bande ne doit pas dépasser 100 caractères.'],
            'date_mortalite'  => ['required' => 'La date de mortalité est requise.'],
            'nombreMort'      => ['required' => 'Le nombre de morts est requis.',
                                    'integer' => 'Le nombre de morts doit être un nombre.'],
        ]; 

        if (!$this->validate($rules, $messages)) {
            $response = [
                'status' => 200,
                'error' => true,
                'messages' => 'Erreur de validation',
                'message' => $this->validator->getErrors(),
                'data' => [],
            ];
           
            return $this->respondCreated($response);
        }
        
        // Préparer les données à insérer
        $insertData = [
            'bande_id'      => $data['bande_id'],
            'date_mortalite'      => $data['date_mortalite'],
            'nombre'        => $data['nombreMort'],
            'cause'    => $data['cause']
        ];

        $mort = $this->mortaliteModel->getMortaliteById($data['bande_id']);
        if(!$mort){
            $bande = $this->bandeModel->getBandeById($data['bande_id']);
            $ancien =$bande['nb_initial']-$bande['nb_mort'];
            $insertData['quantite_ancien'] = $ancien;
            $insertData['quantite_restant'] = $ancien-$data['nombreMort'];
        }
        else {
            $insertData['quantite_ancien'] = $mort['quantite_restant'];
            $insertData['quantite_restant'] = $mort['quantite_restant']-$data['nombreMort'];
        }        

        if ($this->mortaliteModel->insert($insertData) === false) {
            $response = [
                'status' => 200,
                'error' => true,
                'messages' => 'Erreur lors de l\'enregistrement de la mortalité',
                'message' => $this->validator->getErrors(),
                'data' => [],
            ];

            return $this->respondCreated($response);
        }

        
        $insertData['id'] = $this->mortaliteModel->getInsertID();
        $response = [
            'status' => 200,
            'error' => false,
            'messages' => 'Mortalité enregistrée avec succès',
            'message' => null,
            'data' => $insertData,
        ];
        
        return $this->respondCreated($response);
    }

    /**
     * Return the editable properties of a resource object.
     *
     * @param int|string|null $id
     *
     * @return ResponseInterface
     */
    public function edit($id = null)
    {
        //
    }

    /**
     * Add or update a model resource, from "posted" properties.
     *
     * @param int|string|null $id
     *
     * @return ResponseInterface
     */
    public function update($id = null)
    {
        //
    }

    /**
     * Delete the designated resource object from the model.
     *
     * @param int|string|null $id
     *
     * @return ResponseInterface
     */
    public function delete($id = null)
    {
        //
    }
}
