<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Utilisateur extends Migration
{
    public function up(){
        $this->forge->addField([
            'id'=> [
                'type'=> 'INT',
                'auto_increment' => true
            ],
            'nom'=> [
                'type'=> 'TEXT',
            ],
            'email'=> [ 
                'type'=> 'TEXT',
            ], 
            'password'=> [ 
                'type'=> 'TEXT',
            ], 
            'ipAddress'=> [ 
                'type'=> 'TEXT',
            ], 
            'role'=> [ 
                'type'=> 'TEXT',
            ], 
            'etat'=> [ 
                'type'=> 'INT',
            ],
            'statut' => [
                'type'=> 'ENUM',
                'constraint'=> ['active', 'delete'],
                'default'=> 'active',
            ],
            'last_connect' => [
                'type'=> 'datetime',
                'null'=>true
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime default current_timestamp'
         ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('utilisateur'); 
    }

    public function down() {
        $this->forge->dropTable('utilisateur');  
    }
}
