<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Ferme extends Migration
{
    public function up(){
        $this->forge->addField([
            'id'=> [
                'type'=> 'INT',
                'auto_increment'=> true
            ],
            'nom'=> [
                'type'=> 'TEXT',
            ],
            'localisation' => [ 
                'type' => 'TEXT',
            ], 
            'utilisateur_id' => [ 
                'type'=> 'INT',
            ],
            'statut' => [
                'type'=> 'ENUM',
                'constraint'=> ['active', 'delete'],
                'default'=> 'active',
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime default current_timestamp'
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('utilisateur_id','utilisateur','id');
        $this->forge->createTable('ferme'); 
    }

    public function down() {
        $this->forge->dropTable('ferme');  
    }
}
