<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Bande extends Migration
{
    public function up(){
        $this->forge->addField([
            'id'=> [
                'type'=> 'INT',
                'auto_increment'=> true
            ],
            'ferme_id'=> [
                'type'=> 'INT',
            ],
            'nb_initial'=> [
                'type'=> 'INT',
            ],
            'nb_mort'=> [
                'type'=> 'INT',
            ],
            'poids_moyen'=> [
                'type'=> 'DECIMAL',
            ],
            'date_debut'=> [
                'type'=> 'datetime',
                'null'=>true
            ],
            'date_fin'=> [
                'type'=> 'datetime',
                'null'=>true
            ], 
            'ferme_id' => [ 
                'type'=> 'INT',
            ],
            'statut' => [
                'type'=> 'ENUM',
                'constraint'=> ['active', 'en cours', 'terminer', 'delete'],
                'default'=> 'active',
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime default current_timestamp'
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('ferme_id','ferme','id');
        $this->forge->createTable('bande'); 
    }

    public function down() {
        $this->forge->dropTable('bande');  
    }
}
