<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Vente extends Migration
{
    public function up(){
        $this->forge->addField([
            'id'=> [
                'type'=> 'INT',
                'auto_increment'=> true
            ],
            'bande_id'=> [
                'type'=> 'INT',
            ],
            'quantite'=> [
                'type'=> 'INT',
            ],
            'prix_vente'=> [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'default' => '0.00',
            ],
            'montant_total'=> [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'default' => '0.00',
            ],
            'date'=> [
                'type'=> 'datetime',
                'null'=>true
            ],
            'statut' => [
                'type'=> 'ENUM',
                'constraint'=> ['active', 'delete'],
                'default'=> 'active',
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime default current_timestamp'
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('bande_id','bande','id');
        $this->forge->createTable('vente'); 
    }

    public function down() {
        $this->forge->dropTable('vente');  
    }
}
