<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Stock extends Migration
{
    public function up(){
        $this->forge->addField([
            'id'=> [
                'type'=> 'INT',
                'auto_increment'=> true
            ],
            'bande_id'=> [
                'type'=> 'INT',
            ],
            'ferme_id'=> [
                'type'=> 'INT',
            ],
            'quantite'=> [
                'type'=> 'FLOAT',
            ],
            'type'=> [
                'type'=> 'TEXT',
            ],
            'nom_produit'=> [
                'type'=> 'TEXT',
            ],
            'prix_achat'=> [
                'type'=> 'FLOAT',
            ],
            'statut' => [
                'type'=> 'ENUM',
                'constraint'=> ['active', 'delete'],
                'default'=> 'active',
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime default current_timestamp'
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('bande_id','bande','id');
        $this->forge->addForeignKey('ferme_id','ferme','id');
        $this->forge->createTable('stock'); 
    }

    public function down() {
        $this->forge->dropTable('stock');  
    }
}
