<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Materiel extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'auto_increment' => true,
            ],
            'nom' => [
                'type'       => 'TEXT'
            ],
            'cout' => [
                'type' => 'FLOAT',
            ],
            'date_acquisition'=> [
                'type'=> 'datetime',
                'null'=>true
            ],
            'ferme_id' => [
                'type' => 'INT',
            ],
            'bande_id' => [
                'type' => 'INT',
            ],
            'statut' => [
                'type'       => 'ENUM',
                'constraint' => ['active', 'delete'],
                'default'    => 'active',
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime default current_timestamp'
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('ferme_id', 'ferme', 'id');
        $this->forge->addForeignKey('bande_id', 'bande', 'id');
        $this->forge->createTable('materiel');
    }

    public function down()
    {
        $this->forge->dropTable('materiel');
    }
}
