<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Aliment extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'auto_increment' => true,
            ],
            'nom' => [
                'type'       => 'TEXT'
            ],
            'prix_unitaire' => [
                'type' => 'FLOAT',
            ],
            'statut' => [
                'type'       => 'ENUM',
                'constraint' => ['active','terminer', 'delete'],
                'default'    => 'active',
            ],
            'ferme_id' => [
                'type' => 'INT'
            ],
            'type_aliment' => [
                'type'       => 'ENUM',
                'constraint' => ['démarrage', 'croissance', 'finition'],
                'default'    => 'démarrage'
            ],
            'nbre_sac' => [
                'type' => 'FLOAT'
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime default current_timestamp'
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('ferme_id', 'ferme', 'id');
        $this->forge->createTable('aliment');
    }

    public function down()
    {
        $this->forge->dropTable('aliment');
    }
}
