<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Reinvestissement extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'auto_increment' => true,
            ],
            'actionnaire_id' => [
                'type' => 'INT',
            ],
            'montant' => [
                'type' => 'FLOAT',
            ],
            'bande_id' => [
                'type' => 'INT',
            ],
            'statut' => [
                'type'       => 'ENUM',
                'constraint' => ['active', 'delete'],
                'default'    => 'active',
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime default current_timestamp'
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('actionnaire_id', 'actionnaire', 'id');
        $this->forge->addForeignKey('bande_id', 'bande', 'id');
        $this->forge->createTable('reinvestissement');
    }

    public function down()
    {
        $this->forge->dropTable('reinvestissement');
    }
}
