<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Medicament extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'auto_increment' => true,
            ],
            'nom' => [
                'type'       => 'TEXT'
            ],
            'prix_unitaire' => [
                'type' => 'FLOAT',
            ],
            'ferme_id' => [
                'type' => 'INT'
            ],
            'statut' => [
                'type'       => 'ENUM',
                'constraint' => ['active','terminer', 'delete'],
                'default'    => 'active',
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime default current_timestamp'
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('ferme_id', 'ferme', 'id');
        $this->forge->createTable('medicament');
    }

    public function down()
    {
        $this->forge->dropTable('medicament');
    }
}