<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class DistributionAliment extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'auto_increment' => true,
            ],
            'bande_id' => [
                'type' => 'INT',
            ],
            'aliment_id' => [
                'type' => 'INT',
            ],
            'date' => [
                'type'=> 'datetime',
                'null'=>true
            ],
            'quantite' => [
                'type' => 'FLOAT',
            ],
            'statut' => [
                'type'       => 'ENUM',
                'constraint' => ['active', 'delete'],
                'default'    => 'active',
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime default current_timestamp'
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('bande_id', 'bande', 'id');
        $this->forge->addForeignKey('aliment_id', 'aliment', 'id');
        $this->forge->createTable('distribution_aliment');
    }

    public function down()
    {
        $this->forge->dropTable('distribution_aliment');
    }
}
