<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class StockMedicament extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'auto_increment' => true,
            ],
            'medicament_id' => [
                'type' => 'INT',
            ],
            'bande_id' => [
                'type' => 'INT',
            ],
            'quantite_initiale' => [
                'type' => 'FLOAT',
            ],
            'quantite_utilisee' => [
                'type' => 'FLOAT',
            ],
            'date_entree' => [
                'type'=> 'datetime',
                'null'=>true
            ],
            'statut' => [
                'type'       => 'ENUM',
                'constraint' => ['active', 'delete'],
                'default'    => 'active',
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime default current_timestamp'
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('medicament_id', 'medicament', 'id');
        $this->forge->addForeignKey('bande_id', 'bande', 'id');
        $this->forge->createTable('stock_medicament');
    }

    public function down()
    {
        $this->forge->dropTable('stock_medicament');
    }
}
