<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AdministrationTraitement extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'auto_increment' => true,
            ],
            'bande_id' => [
                'type' => 'INT',
            ],
            'medicament_id' => [
                'type' => 'INT',
            ],
            'dose' => [
                'type' => 'FLOAT',
            ],
            'date' => [
                'type'=> 'datetime',
                'null'=>true
            ],
            'statut' => [
                'type'       => 'ENUM',
                'constraint' => ['active', 'delete'],
                'default'    => 'active',
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime default current_timestamp'
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('bande_id', 'bande', 'id');
        $this->forge->addForeignKey('medicament_id', 'medicament', 'id');
        $this->forge->createTable('distribution_medicament');
    }

    public function down()
    {
        $this->forge->dropTable('distribution_medicament');
    }
}
