<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Investissement extends Migration
{
    public function up(){
        $this->forge->addField([
            'id'=> [
                'type'=> 'INT',
                'auto_increment'=> true
            ],
            'bande_id'=> [
                'type'=> 'INT',
            ],
            'actionnaire_id'=> [
                'type'=> 'INT',
            ],
            'montant_investi'=> [
                'type'=> 'FLOAT',
            ],
            'statut' => [
                'type'=> 'ENUM',
                'constraint'=> ['active', 'delete'],
                'default'=> 'active',
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime default current_timestamp'
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('bande_id','bande','id');
        $this->forge->addForeignKey('actionnaire_id','actionnaire','id');
        $this->forge->createTable('investissement'); 
    }

    public function down() {
        $this->forge->dropTable('investissement');  
    }
}
