<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterBande extends Migration
{
    public function up()
    {
        $fields = [
            'entreprise' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => true,
                'after' => 'ferme_id'
            ],
            'souche' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => true,
                'after' => 'entreprise'
            ],
        ];
        $this->forge->addColumn('bande', $fields);
    }

    public function down()
    {
        $this->forge->dropColumn('bande', ['entreprise', 'souche']);
    }
}
