<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterAliment extends Migration
{
    public function up()
    {
        $fields = [
            'quantite' => [
                'type' => 'FLOAT',
                'after' => 'prix_unitaire'
            ],
            'total' => [
                'type' => 'FLOAT',
                'after' => 'quantite'
            ],
            'fournisseur' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => true,
                'after' => 'total'
            ],
        ];
        $this->forge->addColumn('aliment', $fields);
    }

    public function down()
    {
        $this->forge->dropColumn('aliment', ['quantite', 'fournisseur', 'total']);
    }
}
