<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Mortalite extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'auto_increment' => true
            ],
            'bande_id' => [
                'type'       => 'INT',
            ],
            'date_mortalite' => [
                'type' => 'DATE',
            ],
            'nombre' => [
                'type' => 'INT',
            ],
            'cause' => [
                'type' => 'VARCHAR',
                'constraint' => 150,
                'null' => true,
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime null'
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('bande_id', 'bande', 'id');
        $this->forge->createTable('mortalite');
    }

    public function down()
    {
        $this->forge->dropTable('mortalite');
    }
}
