<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterMortalite extends Migration
{
    public function up()
    {
        $fields = [
            'quantite_ancien' => [
                'type' => 'INT',
                'after' => 'nombre'
            ],
            'quantite_restant' => [
                'type' => 'INT',
                'after' => 'quantite_ancien'
            ]
        ];
        $this->forge->addColumn('mortalite', $fields);
    }

    public function down()
    {
        $this->forge->dropColumn('mortalite', ['quantite_ancien', 'quantite_restant']);
    }
}
