<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterMedicament extends Migration
{
    public function up()
    {
        $fields = [
            'quantite' => [
                'type' => 'FLOAT',
                'after' => 'prix_unitaire'
            ],
            'total' => [
                'type' => 'FLOAT',
                'after' => 'quantite'
            ],
            'type' => [
                'type' => 'TEXT',
                'after' => 'total'
            ],
            'id_bande' => [
                'type' => 'INT',
                'after' => 'ferme_id',
                'default'=> 1
            ]
        ];
        $this->forge->addColumn('medicament', $fields);
    }

    public function down()
    {
        $this->forge->dropColumn('medicament', ['quantite','total','type','id_bande']);
    }
}
