<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CoutProductionBande extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'bande_id' => [
                'type' => 'INT',
            ],
            'ferme_id' => [
                'type' => 'INT',
            ],
            'date_jour' => [
                'type' => 'DATE',
            ],
            'cout_production' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'default' => '0.00',
            ],
            'age_jours' => [
                'type' => 'INT',
                'null' => true,
            ],
            'note' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime null',
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->addForeignKey('bande_id', 'bande', 'id');
        $this->forge->addForeignKey('ferme_id', 'ferme', 'id');
        $this->forge->createTable('cout_production_bande');
    }

    public function down()
    {
        $this->forge->dropTable('cout_production_bande');
    }
}
