<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class BeneficeVenteBande extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'vente_id' => [
                'type' => 'INT',
            ],
            'ferme_id' => [
                'type' => 'INT',
            ],
            'bande_id' => [
                'type' => 'INT',
            ],
            'date_vente' => [
                'type' => 'DATE',
            ],
            'montant_vente' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'default' => '0.00',
            ],
            'cout_production' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'null' => true,
            ],
            'benefice' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'null' => true,
            ],
            'note' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
            ],
            'created_at datetime default current_timestamp',
            'updated_at datetime default current_timestamp on update current_timestamp',
            'deleted_at datetime null',
        ]);

        $this->forge->addPrimaryKey('id');
        $this->forge->addUniqueKey('vente_id');
        $this->forge->addKey('bande_id');
        $this->forge->addForeignKey('vente_id', 'vente', 'id');
        $this->forge->addForeignKey('bande_id', 'bande', 'id');
        $this->forge->addForeignKey('ferme_id', 'ferme', 'id');
        $this->forge->createTable('benefice_vente_bande');
    }

    public function down()
    {
        $this->forge->dropTable('benefice_vente_bande');
    }
}
