<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterVenteAddFermeId extends Migration
{
    public function up()
    {
        $fields = [
            'ferme_id' => [
                'type' => 'INT',
                'null' => false,
                'after' => 'bande_id'
            ],
        ];

        $this->forge->addColumn('vente', $fields);
        $this->forge->addForeignKey('ferme_id', 'ferme', 'id');
        // Add foreign key constraint (MySQL)
       // $this->db->query('ALTER TABLE vente ADD CONSTRAINT fk_vente_ferme FOREIGN KEY (ferme_id) REFERENCES ferme(id)');
    }

    public function down()
    {
        // Drop foreign key constraint then column
       // $this->db->query('ALTER TABLE vente DROP FOREIGN KEY fk_vente_ferme');
        $this->forge->dropColumn('vente', 'ferme_id');
    }
}
