<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterBeneficeAddPrixUnitaire extends Migration
{
    public function up()
    {
        $fields = [
            'prix_unitaire' => [
                'type' => 'INT',
                'null' => false,
                'default' => 0,
                'after' => 'montant_vente'
            ],
            'benefice_unitaire' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'default' => '0.00',
                'after' => 'prix_unitaire'
            ]
        ];

        $this->forge->addColumn('benefice_vente_bande', $fields);
    }

    public function down()
    {
        $this->forge->dropColumn('benefice_vente_bande', ['prix_unitaire', 'benefice_unitaire']);
    }
}
