<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterVenteAddPrixUnitaireTotalVente extends Migration
{
    public function up()
    {
        $fields = [
            'prix_unitaire' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'default' => '0.00',
                'null' => false,
                'after' => 'prix_vente'
            ],
            'total_vente' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'default' => '0.00',
                'null' => false,
                'after' => 'montant_total'
            ],
        ];

        $this->forge->addColumn('vente', $fields);
    }

    public function down()
    {
        $this->forge->dropColumn('vente', 'prix_unitaire');
        $this->forge->dropColumn('vente', 'total_vente');
    }
}
