<?php

namespace App\Models;

use CodeIgniter\Model;

class AlimentModel extends Model
{
    protected $table            = 'aliment';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields = [
        'nom',
        'prix_unitaire',
        'quantite',
        'total',
        'fournisseur',
        'type_aliment',
        'nbre_sac',
        'statut',
        'ferme_id',
        'created_at',
        'updated_at',
        'deleted_at',
        'id_bande'
    ];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    function getAlimentByFermeID($idFerme,$statut) {   
        return $this->select('aliment.*, ferme.nom as ferme_nom, localisation,utilisateur_id')
                    ->join('ferme', 'ferme.id = aliment.ferme_id', 'left')
                    ->where('aliment.ferme_id', $idFerme)
                    ->where('aliment.statut', $statut)
                    ->orderBy('aliment.created_at', 'ASC')
                    ->findAll(); 
    }

    function getAliments($iduser) {   
        return $this->select('aliment.*, ferme.nom as ferme_nom, localisation, localisation as servie, localisation as reste')
                    ->join('ferme', 'ferme.id = aliment.ferme_id', 'left')
                    ->where('ferme.utilisateur_id', $iduser)
                    ->orderBy('aliment.created_at', 'DESC')
                    ->findAll(); 
    }

    function countTotalAliments($idUser) {
        $req =  $this->table('aliment')
                    ->select('COALESCE(sum(quantite),0) as total_quantite, COALESCE(sum(total),0) as total_prix, count(*) as total')
                    ->join('ferme', 'ferme.id = aliment.ferme_id')
                    ->where('ferme.utilisateur_id', $idUser)
                    ->get();
        return $req->getRow();
    }

    function countTotalAlimentsBande($idUser,$bande_id) {
        $req =  $this->table('aliment')
                    ->select('COALESCE(sum(quantite),0) as total_quantite, COALESCE(sum(total),0) as total_prix, count(*) as total')
                    ->join('ferme', 'ferme.id = aliment.ferme_id')
                    ->where('ferme.utilisateur_id', $idUser)
                    ->where('aliment.id_bande', $bande_id)
                    ->get();
        return $req->getRow();
    }

    function getAlimentResteByBandeUserID($userId, $statut = 'active', $bande_id) {   
        return $this->select('aliment.*, ferme.nom as ferme_nom, localisation, localisation as servie, localisation as reste')
                    ->join('ferme', 'ferme.id = aliment.ferme_id', 'left')
                    ->join('utilisateur', 'utilisateur.id = ferme.utilisateur_id', 'left')
                    ->where('utilisateur.id', $userId)
                    ->where('aliment.statut', $statut)
                    ->where('aliment.id_bande', $bande_id)
                    ->orderBy('aliment.created_at', 'DESC')
                    ->findAll(); 
    }
    function getAlimentByBandeUserID($userId, $bande_id) {   
        return $this->select('aliment.*, ferme.nom as ferme_nom, localisation, localisation as servie, localisation as reste')
                    ->join('ferme', 'ferme.id = aliment.ferme_id', 'left')
                    ->join('utilisateur', 'utilisateur.id = ferme.utilisateur_id', 'left')
                    ->where('utilisateur.id', $userId)
                    ->where('aliment.id_bande', $bande_id)
                    ->orderBy('aliment.created_at', 'DESC')
                    ->findAll(); 
    }
}
