<?php

namespace App\Models;

use CodeIgniter\Model;

class BandeModel extends Model
{
    protected $table            = 'bande';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields = [
        'libelle',
        'date_debut',
        'date_fin',
        'statut',
        'ferme_id',
        'entreprise',
        'souche',
        'nb_initial',
        'nb_mort',
        'poids_moyen',
        'created_at',
        'updated_at',
        'deleted_at',
        'prix_unitaire',
        'total'
    ];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    function loadBandeByUserId($ferme_id, $etat){
        return $this->select('bande.*, ferme.nom as ferme_nom, localisation')
                    ->join('ferme', 'ferme.id = bande.ferme_id', 'left')
                    ->where('bande.statut', $etat)
                    ->where('ferme_id',$ferme_id)
                    ->orderBy('bande.libelle', 'ASC')
                    ->findAll();
    }

    function getBandeByIdEtat($id, $etat) {   
        return $this->select('bande.*, ferme.nom as ferme_nom, localisation')
                    ->join('ferme', 'ferme.id = bande.ferme_id', 'left')
                    ->where('bande.statut', $etat)
                    ->find($id);
    }

    function getBandeById($id) {   
        return $this->select('bande.*, ferme.nom as ferme_nom, localisation')
                    ->join('ferme', 'ferme.id = bande.ferme_id', 'left')
                    ->find($id);
    }

    function loadBande($etat){
        return $this->select('bande.*, ferme.nom as ferme_nom, localisation')
                    ->join('ferme', 'ferme.id = bande.ferme_id', 'left')
                    ->where('bande.statut', $etat)
                    ->orderBy('bande.libelle', 'ASC')
                    ->findAll();
    }

    function loadBandeNot($etat){
        return $this->select('bande.*, ferme.nom as ferme_nom, localisation')
                    ->join('ferme', 'ferme.id = bande.ferme_id', 'left')
                    ->where('bande.statut!=', $etat)
                    ->orderBy('bande.libelle', 'ASC')
                    ->findAll();
    }

    function getBandeByFerme($idFerme, $userId){
        return $this->select('bande.*, ferme.nom as ferme_nom, localisation')
                    ->join('ferme', 'ferme.id = bande.ferme_id', 'left')
                    ->where('bande.ferme_id', $idFerme)
                    ->where('ferme.utilisateur_id', $userId)
                    ->where('bande.statut!=','terminer')
                    ->orderBy('bande.libelle', 'ASC')
                    ->findAll();     
    }

    function getTotalBande($bande_id) {   
        $row = $this->where('id', $bande_id)
                   // ->where('ferme_id', $ferme_id)
                    ->first();
        return $row ? (int)$row['nb_initial'] : 0;
    }

    function getTotalMortCartonBande($bande_id) {   
        $row = $this->where('id', $bande_id)
                    //->where('utilisateur_id', $idUser)
                    ->first();
        return $row ? (int)$row['nb_mort'] : 0;
    }

    function getActiveBandeByFerme($idFerme){
        return  $this->select('bande.*')
                    ->where('bande.statut', 'active')
                    ->where('bande.ferme_id', $idFerme)
                    ->first();  
    }

    function countBande($idFerme) {   
        $row = $this->select('count(id) as total')
                    ->where('ferme_id', $idFerme)
                    ->first();
        return $row ? (int)$row['total'] : 0;
    }

    public function getAvantDerniereBande($ferme_id)
    {
        $bandes = $this->select('id')
                    ->where('ferme_id', $ferme_id)
                    ->orderBy('date_debut', 'DESC')
                    ->findAll(2); // récupère les 2 plus récents

        return isset($bandes[1]) ? (int)$bandes[1]['id'] : 0;  
    }

    public function getAvantDerniereBandeV2($ferme_id) {
    $bandes = $this->select('id')
                   ->where('ferme_id', $ferme_id)
                   ->orderBy('date_debut', 'DESC')
                   ->findAll(1, 1); // récupère le 2e enregistrement uniquement

    return !empty($bandes) ? (int)$bandes[0]['id'] : 0;  
    }
}
