<?php

namespace App\Models;

use CodeIgniter\Model;

class BeneficeVenteBandeModel extends Model
{
    protected $table            = 'benefice_vente_bande';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'vente_id',
        'bande_id',
        'date_vente',
        'montant_vente',
        'quantite',
        'cout_production',
        'benefice',
        'note',
        'created_at',
        'updated_at',
        'deleted_at',
        'ferme_id',
        'prix_unitaire',
        'benefice_unitaire'
    ];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
}
