<?php

namespace App\Models;

use CodeIgniter\Model;

class CoutProductionBandeModel extends Model
{
    protected $table            = 'cout_production_bande';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'bande_id',
        'date_jour',
        'cout_production',
        'age_jours',
        'note',
        'created_at',
        'updated_at',
        'deleted_at',
        'ferme_id'
    ];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;

    public function getCostByDate(int $bande_id, string $date)
    {
        return $this->where('bande_id', $bande_id)
                    ->where('date_jour', $date)
                    ->first();
    }

    public function getLatestCostBefore(int $bande_id, string $date)
    {
        return $this->where('bande_id', $bande_id)
                    ->where('date_jour <=', $date)
                    ->orderBy('date_jour', 'DESC')
                    ->first();
    }
}
