<?php

namespace App\Models;

use CodeIgniter\Model;

class DistributionAlimentModel extends Model
{
    protected $table            = 'distribution_aliment';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'bande_id',
        'aliment_id',
        'date',
        'quantite',
        'statut',
        'created_at',
        'updated_at',
        'deleted_at'
    ];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    function getSumAlimentDistribuer($aliment_id) {   
        $res =  $this->table('distribution_aliment')
                    ->select('sum(quantite) as servie')
                    ->where('aliment_id', $aliment_id)
                    ->get();
        return $res->getRow()->servie??0;
    }

    function getSumAlimentDistribuerBande($aliment_id,$bandeId) {   
        $res =  $this->table('distribution_aliment')
                    ->select('sum(quantite) as servie')
                    ->where('aliment_id', $aliment_id)
                    ->where('bande_id', $bandeId)
                    ->get();
        return $res->getRow()->servie??0;
    }

    function getAlimentDistribuerByUSerID($userId, $idBande) {   
        return $this->select('distribution_aliment.*, aliment.nom as aliment_nom,type_aliment, fournisseur, aliment.statut as aliment_statut, aliment.prix_unitaire, aliment.quantite as quantite_aliment,aliment.nbre_sac as nbresac, aliment.total,
        ferme.nom as ferme_nom, localisation, bande.libelle as nom_bande, entreprise, souche')
                    ->join('aliment', 'aliment.id = aliment_id', 'left')
                    ->join('bande', 'bande.id = bande_id', 'left')
                    ->join('ferme', 'ferme.id = aliment.ferme_id', 'left')
                    ->join('utilisateur', 'utilisateur.id = ferme.utilisateur_id', 'left')
                    ->where('utilisateur_id',$userId)
                    ->where('bande.id', $idBande)
                    //->where('distribution_aliment.aliment_id', $idAliment)
                    ->orderBy('distribution_aliment.created_at', 'ASC')
                    ->findAll(); 
    }

    function getTotalDistributionAlimentsBande($bande_id){
        $res = $this->select('SUM(distribution_aliment.quantite) as total_distribue')
                    ->where('distribution_aliment.bande_id', $bande_id)
                    ->first();
        return $res ? (float)$res['total_distribue'] : 0;
    }

    function getTotalDistributionAliments(){
        $res = $this->select('SUM(distribution_aliment.quantite) as total_distribue')
                    ->first();
        return $res ? (float)$res['total_distribue'] : 0;
    }
}