<?php

namespace App\Models;

use CodeIgniter\Model;

class DistributionMedicamentModel extends Model
{
    protected $table            = 'distribution_medicament';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields = [
        'bande_id',
        'medicament_id',
        'dose',
        'date',
        'statut',
        'created_at',
        'updated_at',
        'deleted_at'
    ];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    function getMedicamentDistribuerByUSerID($userId, $Idbande) {   
        return $this->select('distribution_medicament.*, medicament.nom as medicament_nom, type, 
                        medicament.statut as medicament_statut, medicament.prix_unitaire, medicament.quantite as quantite_aliment,
                        medicament.total, ferme.nom as ferme_nom, localisation, 
                        bande.libelle as nom_bande, entreprise, souche')
                    ->join('medicament', 'medicament.id = medicament_id', 'left')
                    ->join('bande', 'bande.id = bande_id', 'left')
                    ->join('ferme', 'ferme.id = medicament.ferme_id', 'left')
                    ->join('utilisateur', 'utilisateur.id = ferme.utilisateur_id', 'left')
                    ->where('utilisateur_id',$userId)
                    ->where('bande.id',$Idbande)
                    ->orderBy('distribution_medicament.created_at', 'ASC')
                    ->findAll(); 
    }

    function getSumMedicamentDistribuer($medicament_id) {   
        $res =  $this->table('distribution_medicament')
                    ->select('sum(dose) as servie')
                    ->where('medicament_id', $medicament_id)
                    ->get();
        return $res ? (float)$res->getRow()->servie : 0;
    }

    function getSumMedicamentDistribuerBande($medicament_id, $bandeId) {   
        $res =  $this->table('distribution_medicament')
                    ->select('sum(dose) as servie')
                    ->where('medicament_id', $medicament_id)
                    ->where('bande_id', $bandeId)
                    ->get();
        return $res ? (float)$res->getRow()->servie : 0;
    }

    function getTotalDistributionMedicamentsBande($bande_id){
        $res = $this->select('SUM(distribution_medicament.dose) as total_distribue')
                    ->where('distribution_medicament.bande_id', $bande_id)
                    ->first();
        return $res ? (float)$res['total_distribue'] : 0;
    }

    function getTotalDistributionMedicaments(){
        $res = $this->select('SUM(distribution_medicament.dose) as total_distribue')
                    ->first();
        return $res ? (float)$res['total_distribue'] : 0;
    }
}
