<?php

namespace App\Models;

use CodeIgniter\Model;

class FermeModel extends Model
{
    protected $table            = 'ferme';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'nom',
        'localisation',
        'utilisateur_id',
        'statut',
        'created_at',
        'updated_at',
        'deleted_at'
    ];
    // Model configuration
    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    function loadFermeByUserId($userId, $etat){
        return $this->select('ferme.*, utilisateur.nom as utilisateur_nom')
                    ->join('utilisateur', 'utilisateur.id = ferme.utilisateur_id', 'left')
                    ->where('ferme.statut', $etat)
                    ->where('utilisateur_id',$userId)
                    ->orderBy('ferme.nom', 'ASC')
                    ->findAll();
    }

    function getFermeById($id, $etat) {   
        return $this->select('ferme.*, utilisateur.nom as utilisateur_nom')
                    ->join('utilisateur', 'utilisateur.id = ferme.utilisateur_id', 'left')
                    ->where('ferme.statut', $etat)
                    ->find($id);
    }

    function loadFerme($etat){
        return $this->select('ferme.*, utilisateur.nom as utilisateur_nom')
                    ->join('utilisateur', 'utilisateur.id = ferme.utilisateur_id', 'left')
                    ->where('ferme.statut', $etat)
                    ->orderBy('ferme.nom', 'ASC')
                    ->findAll();
    }

    function getOneFermeById($id, $etat) {   
        return $this->select('ferme.*, utilisateur.nom as utilisateur_nom')
                    ->join('utilisateur', 'utilisateur.id = ferme.utilisateur_id', 'left')
                    ->where('ferme.statut', $etat)
                    ->where('ferme.id', $id)
                    ->first();
    }
}
