<?php

namespace App\Models;

use CodeIgniter\Model;

class MedicamentModel extends Model
{
    protected $table            = 'medicament';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields = [
        'ferme_id',
        'nom',
        'prix_unitaire',
        'quantite',
        'type',
        'total',
        'statut',
        'created_at',
        'updated_at',
        'deleted_at',
        'id_bande'
    ];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    function getMedicamentByUserID($userId) {   
        return $this->select('medicament.*, ferme.nom as ferme_nom, localisation, localisation as servie, localisation as reste')
                    ->join('ferme', 'ferme.id = medicament.ferme_id', 'left')
                    ->join('utilisateur', 'utilisateur.id = ferme.utilisateur_id', 'left')
                    ->where('utilisateur.id', $userId)
                    //->where('medicament.statut', $statut)
                    //->orderBy('medicament.statut', 'ASC')
                    ->orderBy('medicament.created_at', 'DESC')
                    ->findAll(); 
    }

    function getMedicamentActiveByUserID($userId , $statut = 'active') {   
        return $this->select('medicament.*, ferme.nom as ferme_nom, localisation, localisation as servie, localisation as reste')
                    ->join('ferme', 'ferme.id = medicament.ferme_id', 'left')
                    ->join('utilisateur', 'utilisateur.id = ferme.utilisateur_id', 'left')
                    ->where('utilisateur.id', $userId)
                    ->where('medicament.statut', $statut)
                    //->orderBy('medicament.statut', 'ASC')
                    ->orderBy('medicament.created_at', 'DESC')
                    ->findAll(); 
    }

    function getMedicamentByFermeID($idFerme, $statut) {   
        return $this->select('medicament.*, ferme.nom as ferme_nom, localisation')
                    ->join('ferme', 'ferme.id = medicament.ferme_id', 'left')
                    ->join('utilisateur', 'utilisateur.id = ferme.utilisateur_id', 'left')    
                    ->where('medicament.ferme_id', $idFerme)
                    ->where('medicament.statut', $statut)
                    ->orderBy('medicament.created_at', 'ASC')
                    ->findAll(); 
    }

    function countTotalMedicaments($idUser) {
        $req =  $this->table('medicament')
                    ->select('COALESCE(sum(quantite),0) as total_quantite, COALESCE(sum(total),0) as total_prix, count(*) as total')
                    ->join('ferme', 'ferme.id = medicament.ferme_id')
                    ->where('ferme.utilisateur_id', $idUser)
                    ->get();
        return $req->getRow();
    }

    function countTotalMedicamentsBande($idUser,$bande_id) {
        $req =  $this->table('medicament')
                    ->select('COALESCE(sum(quantite),0) as total_quantite, COALESCE(sum(total),0) as total_prix, count(*) as total')
                    ->join('ferme', 'ferme.id = medicament.ferme_id')
                    ->where('ferme.utilisateur_id', $idUser)
                    ->where('medicament.id_bande', $bande_id)
                    ->get();
        return $req->getRow();
    }

    function getMedicaments($iduser) {   
        return $this->select('medicament.*, ferme.nom as ferme_nom, localisation')
                    ->join('ferme', 'ferme.id = medicament.ferme_id', 'left')
                    ->where('ferme.utilisateur_id', $iduser)
                    ->orderBy('medicament.created_at', 'ASC')
                    ->findAll(); 
    }

    function getMedicamentResteByBandeUserID($userId, $statut = 'active', $bande_id) {   
        return $this->select('medicament.*, ferme.nom as ferme_nom, localisation, localisation as servie, localisation as reste')
                    ->join('ferme', 'ferme.id = medicament.ferme_id', 'left')
                    ->join('utilisateur', 'utilisateur.id = ferme.utilisateur_id', 'left')
                    ->where('utilisateur.id', $userId)
                    ->where('medicament.statut', $statut)
                    ->where('medicament.id_bande', $bande_id)
                    ->orderBy('medicament.created_at', 'DESC')
                    ->findAll(); 
    }

    function getMedicamentByBandeUserID($userId, $bande_id) {   
        return $this->select('medicament.*, ferme.nom as ferme_nom, localisation, localisation as servie, localisation as reste')
                    ->join('ferme', 'ferme.id = medicament.ferme_id', 'left')
                    ->join('utilisateur', 'utilisateur.id = ferme.utilisateur_id', 'left')
                    ->where('utilisateur.id', $userId)
                    ->where('medicament.id_bande', $bande_id)
                    ->orderBy('medicament.created_at', 'DESC')
                    ->findAll(); 
    }
}
