<?php

namespace App\Models;

use CodeIgniter\Model;

class MortaliteModel extends Model
{
    protected $table            = 'mortalite';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'bande_id',
        'date_mortalite',
        'nombre',
        'cause',
        'quantite_ancien',
        'quantite_restant',
        'created_at',
        'updated_at',
        'deleted_at'
    ];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    function loadMortalite(){
        return $this->select('mortalite.*, ferme.id as fermeId, ferme.nom as ferme_nom, localisation, libelle, nb_initial, nb_mort, bande.id as idBande')
                    ->join('bande', 'bande.id = mortalite.bande_id', 'left')
                    ->join('ferme', 'ferme.id = bande.ferme_id', 'left')
                    ->orderBy('mortalite.date_mortalite', 'desc')
                    ->findAll();
    }

    function getMortaliteById($bande_id) {   
        return $this->where('bande_id', $bande_id)
                    ->orderBy('date_mortalite', 'DESC')
                    ->first();
    }

    function getSujetRestant($bande_id) {   
        $row = $this->where('bande_id', $bande_id)
                    ->orderBy('date_mortalite', 'DESC')
                    ->first();
        return $row ? (int)$row['quantite_restant'] : 0;
    }

    function countTotalMortalites($idBande) {
        $req = $this->select('SUM(mortalite.nombre) as total_mort')
                    //->join('bande', 'bande.id = mortalite.bande_id')
                   // ->join('ferme', 'ferme.id = bande.ferme_id')
                   // ->where('ferme.utilisateur_id', $idUser)
                    ->where('mortalite.bande_id', $idBande)
                    ->first();
        return $req ? (int)$req['total_mort'] : 0;
    }
}
