# API Backend — GestionFerme (Documentation étendue)

Ce guide décrit toutes les routes exposées, comment utiliser Swagger UI et la collection Postman fournie.

## ▶️ Servir la documentation et l'UI
- Dossier de la doc : `backend/docs`
- Swagger UI statique : ouvrir `backend/docs/swagger.html` via un serveur statique (ex. `python3 -m http.server` depuis `backend/docs`).
- Collection Postman : `backend/docs/collections/GestionFerme.postman_collection.json` (Import dans Postman).

## 🔐 Auth
- POST `/api/auths/login`
  - Body: { "email": "user@example.com", "password": "secret" }
  - Réponse 200 (ex) : { "token": "eyJhbGci..." }

## 🐣 Bande
- POST `/api/bande/addBande`
  - Body ex: { "ferme_id": 1, "nb_initial": 100 }
  - Réponse 201: { status: 201, error: false, messages: "Bande créée", data: { id: 1 } }
- GET `/api/bande/loadBande`
  - Réponse 200 (ex): { status: 200, error: false, data: [{ id:1, ferme_id:1, nb_initial:100 }] }

## 🧾 Coût de production
- POST `/api/bande/addCoutProduction`
  - Body ex: { "bande_id": 1, "date_jour": "2026-01-30", "cout_production": 20.00, "age_jours": 35 }
  - Réponse 201 (ex): { status: 201, error: false, messages: "Enregistré", data: { id: 1 } }
- GET `/api/bande/loadCoutProduction`?bande_id=1
  - Réponse 200 (ex): { status: 200, error: false, data: [{ id:1, bande_id:1, date_jour:"2026-01-30", cout_production:20.00 }] }
- GET `/api/bande/showCoutProduction/{id}`
  - Réponse 200 (ex): { status: 200, error: false, data: { id:1, bande_id:1, date_jour:"2026-01-30", cout_production:20.00 } }

## 💰 Vente
- POST `/api/vente/createVente`
  - Body attendu (controller): { "ferme_id":1, "bande_id":1, "prixUnitaire":10, "total":200, "nombre":5, "datevente":"2026-01-30" }
  - Réponse 201 (ex): { status: 201, error: false, messages: "Enregistrement de la vente effectué avec succès", data: { id: 1 } }

## 📈 Bénéfice
- Comportement automatique : quand une **vente** est insérée via le modèle `VenteModel::insert()`, une entrée `benefice_vente_bande` est créée automatiquement en:
  - Récupérant `cout_production` (date exacte ou dernière valeur antérieure)
  - Calculant `cout_total = cout_unitaire * quantite`
  - Calculant `benefice = montant_total - cout_total`
  - Historisant `quantite` et `cout_production` (unitaire)
- POST `/api/vente/createBenefice` (création manuelle)
  - Body ex: { "vente_id":1, "bande_id":1, "date_vente":"2026-01-30", "montant_vente":200, "quantite":5 }
  - Réponse 201: { status: 201, error: false, data: { id: 1 } }
- GET `/api/vente/loadBenefice`
  - Réponse 200 (ex): { status: 200, error: false, data: [{ id:1, vente_id:1, benefice:100.00 }] }
- GET `/api/vente/showBenefice/{id}`
  - Réponse 200 (ex): { status: 200, error: false, data: { id:1, vente_id:1, montant_vente:200.00, cout_production:20.00, quantite:5, benefice:100.00 } }

## 🧪 Tests
- Test ajouté : `backend/tests/unit/CoutBeneficeTest.php` vérifie la création automatique du bénéfice lors d'une vente.
- Exécuter :
  - cd backend && ./vendor/bin/phpunit --filter CoutBeneficeTest

---

## Génération automatique de la collection Postman
Vous pouvez générer la collection Postman automatiquement depuis l'OpenAPI avec l'une des commandes suivantes :

- Via Composer (préféré si vous n'avez pas npm globalement) :
  - `composer docs:postman` (exécute `npx openapi-to-postmanv2` et écrit `docs/collections/GestionFerme-auto.postman_collection.json`)

- Via npm (si vous gérez les dépendances Node) :
  - `npm install --save-dev openapi-to-postmanv2`
  - `npm run generate:postman`

La collection générée sera disponible ici : `backend/docs/collections/GestionFerme-auto.postman_collection.json`.

✅ **Action exécutée** : la collection a été générée automatiquement et écrite dans `backend/docs/collections/GestionFerme-auto.postman_collection.json`.

Vous pouvez la régénérer localement avec l'une des commandes :
- `cd backend && npm run generate:postman` (recommande si vous avez Node installé)
- `composer docs:postman` (utilise `npx` si vous préférez Composer)

Je peux aussi :
- Ajouter un job CI (GitHub Actions) pour régénérer automatiquement la collection à chaque push,
- Ajouter la collection dans le repo de docs publié (GitHub Pages) automatiquement.

Dites-moi si vous voulez que j'ajoute le job CI ou que je pousse la collection ailleurs. ✨
